# Contributing to PGWatch

Thank you for considering contributing to PGWatch! Here are some guidelines to help you get started.

## Code of Conduct

Please read and follow our [Code of Conduct](CODE_OF_CONDUCT.md).

## Communication Channels

The main communication channel for the project is the 
[GitHub repository](https://github.com/cybertec-postgresql/pgwatch). 
Feel free to open issues and participate in discussions there.

## Setting Up the Development Environment

To set up the development environment, please refer to the instructions in the 
[README.md](https://github.com/cybertec-postgresql/pgwatch) file. We use Docker Compose to simplify the setup process.

## How to Report Bugs

If you encounter any bugs, please report them by opening an issue in the 
[GitHub repository issues section](https://github.com/cybertec-postgresql/pgwatch/issues). 
Provide as much detail as possible to help us understand and resolve the issue.

## How to Request Features

If you have a feature request, please start a discussion in the 
[GitHub repository discussions section](https://github.com/cybertec-postgresql/pgwatch/discussions). 
We value your feedback and ideas!

## Submitting Changes

Before submitting any changes, please discuss them in the 
[GitHub repository discussions section](https://github.com/cybertec-postgresql/pgwatch/discussions). 
This helps ensure that your contribution aligns with the project goals and prevents duplicate efforts.

When you are ready to submit your changes, create a pull request. Make sure your pull request:

- Follows the [Go Style Guide](https://google.github.io/styleguide/go/)
- Includes tests for any new functionality or bug fixes

## Coding Standards

We follow the [Go Style Guide](https://google.github.io/styleguide/go/). 
Please ensure your code adheres to these guidelines.

## Testing

We require tests for all changes. Please use the standard Go testing facilities. 
Ensure that all tests pass before submitting your pull request.

## Documentation

Documentation for the project resides in the same repository. If you make changes 
that require documentation updates, please include those changes in your pull request.

## Contributor License Agreement (CLA)

We do not require contributors to sign a Contributor License Agreement (CLA). 
By submitting a pull request, you agree that your contributions are submitted 
under the same license as the project.

---

We appreciate your contributions and efforts to improve PGWatch. If you have any questions, 
feel free to reach out through the [GitHub repository](https://github.com/cybertec-postgresql/pgwatch).

Thank you!
