% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_zeroinflation.R
\name{check_zeroinflation}
\alias{check_zeroinflation}
\title{Check for zero-inflation in count models}
\usage{
check_zeroinflation(x, tolerance = 0.05)
}
\arguments{
\item{x}{Fitted model of class \code{merMod}, \code{glmmTMB}, \code{glm}, or \code{glm.nb}
(package \strong{MASS}).}

\item{tolerance}{The tolerance for the ratio of observed and predicted
zeros to considered as over- or underfitting zeros. A ratio
between 1 +/- \code{tolerance} is considered as OK, while a ratio
beyond or below this threshold would indicate over- or underfitting.}
}
\value{
A list with information about the amount of predicted and observed
zeros in the outcome, as well as the ratio between these two values.
}
\description{
\code{check_zeroinflation()} checks whether count models are
over- or underfitting zeros in the outcome.
}
\details{
If the amount of observed zeros is larger than the amount of
predicted zeros, the model is underfitting zeros, which indicates a
zero-inflation in the data. In such cases, it is recommended to use
negative binomial or zero-inflated models.
}
\examples{
\dontshow{if (require("glmmTMB")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Salamanders, package = "glmmTMB")
m <- glm(count ~ spp + mined, family = poisson, data = Salamanders)
check_zeroinflation(m)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions to check model assumptions and and assess model quality: 
\code{\link{check_autocorrelation}()},
\code{\link{check_collinearity}()},
\code{\link{check_convergence}()},
\code{\link{check_heteroscedasticity}()},
\code{\link{check_homogeneity}()},
\code{\link{check_model}()},
\code{\link{check_outliers}()},
\code{\link{check_overdispersion}()},
\code{\link{check_predictions}()},
\code{\link{check_singularity}()}
}
\concept{functions to check model assumptions and and assess model quality}
